unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OpenGL, StdCtrls, ExtCtrls, Math, GLWektory, ComCtrls, Jpeg;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    StatusBar1: TStatusBar;
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Timer1Timer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseWheel(Sender: TObject; Shift: TShiftState;
      WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
  private
    { Private declarations }
    uchwytDC :HDC; //uchwyt do "display device context (DC)"
    uchwytRC :HGLRC; //uchwyt do "OpenGL rendering context"
    Phi, Theta :Single;
    PozycjaX, PozycjaY, PozycjaZ :Single;
    RuchKamery :Boolean;
    KameraX, KameraY, KameraZ :Single;
    Kolory :Boolean;
    Sfera, SferaTekstura :Boolean;
    Tekstura :array of Longword;
    TeksturaSzer,TeksturaWys :Integer;
    function GL_UstalFormatPikseli(uchwytDC :HDC) :Boolean;
    procedure GL_UstawienieSceny;
    procedure Rysuj;
    procedure RysujOstroslup(x0,y0,z0 :Single);
    procedure RysujOsie(rozmiar :Single);
    procedure GL_Oswietlenie;
    procedure Swiatlo0;
    procedure Swiatlo1;
    procedure Swiatlo2;
    procedure Swiatlo3;
    procedure RysujGLU(rozmiar :Single);
    procedure PrzygotujTeksture;
    procedure Pomoc;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

function TForm1.GL_UstalFormatPikseli(uchwytDC :HDC) :Boolean;
{const OpisFormatuPikseli :PIXELFORMATDESCRIPTOR=(
        nSize:      sizeof(PIXELFORMATDESCRIPTOR);	// wielko
        nVersion:   1;			// wersja
        dwFlags:    PFD_SUPPORT_OPENGL or PFD_DRAW_TO_WINDOW or PFD_DOUBLEBUFFER;	// udostpnienie podwjnego buforowania
        iPixelType: PFD_TYPE_RGBA;	// typ koloru
        cColorBits: 24;			// dana rozdzielczo koloru
        cRedBits:   0;  cRedShift:  0;	// bity koloru(ignorowane)
        cGreenBits: 0;  cGreenShift:0;
        cBlueBits:  0;  cBlueShift: 0;
        cAlphaBits: 0;  cAlphaShift:0;   // wyczenie buforu alfa
        cAccumBits: 0;
        cAccumRedBits:    0;  		// wyczenie akumulacji bufora
        cAccumGreenBits:  0;     	// akumulowanie bitw (ignorowane)
        cAccumBlueBits:   0;
        cAccumAlphaBits:  0;
        cDepthBits:       16;			// wielko bufora
        cStencilBits:     0;			// bez buforu szablonu
        cAuxBuffers:      0;			// bez buforu pomocniczego
        iLayerType:       PFD_MAIN_PLANE;  	// gwna powoka
   bReserved:       0;
   dwLayerMask:     0;
   dwVisibleMask:   0;
   dwDamageMask:    0;  // brak widocznoci powoki, zniszczenie maski
   );}
var
  opisFormatuPikseli :PIXELFORMATDESCRIPTOR;
  formatPikseli :Integer;
begin
Result:=False;
with opisFormatuPikseli do
  begin
  dwFlags:=PFD_SUPPORT_OPENGL or PFD_DRAW_TO_WINDOW or PFD_DOUBLEBUFFER;	//w oknie, podwojne buforowanie
  iPixelType:=PFD_TYPE_RGBA; //typ koloru RGB
  cColorBits:=32; //jakosc kolorw 4 bajty
  cDepthBits:=16; //glebokosc bufora Z (z-buffer)
  iLayerType:=PFD_MAIN_PLANE;
  end;
formatPikseli:=ChoosePixelFormat(uchwytDC, @opisFormatuPikseli);
if (formatPikseli=0) then Exit;
if (SetPixelFormat(uchwytDC, formatPikseli, @opisFormatuPikseli) <> True) then Exit;
Result:=True;
end;

procedure TForm1.GL_UstawienieSceny;
const bialaMgla :TGLArrayf4 = (0.5, 0.5, 0.5, 0.5);
begin
//ustawienie punktu projekcji
glMatrixMode(GL_PROJECTION); //macierz projekcji
//left,right,bottom,top,znear,zfar
//glFrustum(-0.1, 0.1, -0.1, 0.1, 0.3, 25.0); //mnozenie macierzy przez macierz perspektywy
glFrustum(-0.1, 0.1, -0.075, 0.075, 0.3, 25.0); //mnozenie macierzy przez macierz perspektywy
glMatrixMode(GL_MODELVIEW); //powrot do macierzy widoku
glEnable(GL_DEPTH_TEST); //z-buffer aktywny = ukrywanie niewidocznych trojkatow !!!
GL_Oswietlenie;
//przezroczystosc
glEnable(GL_BLEND);
glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
//antialiasing
{glEnable(GL_POINT_SMOOTH);
glEnable(GL_LINE_SMOOTH);
glEnable(GL_POLYGON_SMOOTH);}
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  polozenieMyszy :TPoint;
begin
//biezace okno staje sie oknem OpenGL
uchwytDC:=GetDC(Handle);
GL_UstalFormatPikseli(uchwytDC);
uchwytRC:=wglCreateContext(uchwytDC);
wglMakeCurrent(uchwytDC,uchwytRC);
GL_UstawienieSceny;
Caption:='OpenGL '+glGetString(GL_VERSION);

KameraZ:=10;
RuchKamery:=True;
polozenieMyszy.X:=ClientWidth div 2;
polozenieMyszy.Y:=ClientHeight div 2;
if RuchKamery then Mouse.CursorPos:=ClientToScreen(polozenieMyszy);

Kolory:=True;
Sfera:=False;
SferaTekstura:=False;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
wglMakeCurrent(0,0);
wglDeleteContext(uchwytRC);
ReleaseDC(Handle,uchwytDC);
PostQuitMessage(0);
end;

procedure TForm1.RysujOstroslup(x0,y0,z0 :Single);
const
  wsp_odbicia_szklo :TGLArrayf4 =(1.0,1.0,1.0,1.0);
  wsp_odbicia_matowy :TGLArrayf4 =(0.0,0.0,0.0,1.0);
var
  punkt1,punkt2,punkt3 :TGLArrayf3;
  wektor :TGLArrayf3;
begin
//Rysowanie trojkatow
glBegin(GL_TRIANGLES);
//glBegin(GL_LINE_LOOP);
//ustalanie trzech wierzcholkow trojkata (werteksow (x,y,z))
//(0,0,???) jest mniej wiecej w srodku ekranu

//sciana tylnia
if Kolory then glColor3ub(255,255,0); //zolty
//lsniacy material
glMaterialfv(GL_FRONT,GL_SPECULAR,@wsp_odbicia_szklo);
glMateriali(GL_FRONT,GL_SHININESS,100);
glNormal(0,0,-1.0); //w glab
glVertex3f( -x0, -y0, z0); //dolny lewy
glVertex3f(x0, -y0, z0); //dolny prawy
glVertex3f(0, y0, z0); //gorny
//powrot do oryginalnych
glMaterialfv(GL_FRONT,GL_SPECULAR,@wsp_odbicia_matowy);
glMateriali(GL_FRONT,GL_SHININESS,0);

//podstawa
if Kolory then glColor3ub(0,255,0); //zielony
glNormal(0,-1.0,0); //do dolu
glVertex3f( -x0, -y0, z0); //dolny lewy
glVertex3f(x0, -y0, z0); //dolny prawy
glVertex3f(0, -y0, 2*z0); //dolny przedni

//prawa
if Kolory then glColor3ub(0,0,255); //niebieski
punkt1[0]:=x0;  punkt1[1]:=-y0; punkt1[2]:=z0;
punkt2[0]:=0;   punkt2[1]:=-y0; punkt2[2]:=2*z0;
punkt3[0]:=0;   punkt3[1]:=y0;  punkt3[2]:=z0;
//odwrocone - aby nawijanie bylo prawidlowe (przy def. trojkata tez zmiana kolejnosci)
wektor:=JednostkowyWektorNormalny(punkt1,punkt3,punkt2);
glNormal3fv(@wektor);
glVertex3fv(@punkt1); //glVertex3f(x0, -y0, z0); //dolny prawy
glVertex3fv(@punkt3); //glVertex3f(0, y0, z0); //gorny
glVertex3fv(@punkt2); //glVertex3f(0, -y0, 2*z0); //dolny przedni

//lewa
if Kolory then glColor4ub(255,0,0,128) //czerwony polprzezroczysty
          else glColor4ub(255,255,255,128);
punkt1[0]:=-x0; punkt1[1]:=-y0; punkt1[2]:=z0;
punkt2[0]:=0;   punkt2[1]:=-y0; punkt2[2]:=2*z0;
punkt3[0]:=0;   punkt3[1]:=y0;  punkt3[2]:=z0;
wektor:=JednostkowyWektorNormalny(punkt1,punkt2,punkt3);
glNormal3fv(@wektor);
glVertex3fv(@punkt1); //glVertex3f(-x0, -y0, z0); //dolny lewy
glVertex3fv(@punkt2); //glVertex3f(0, -y0, 2*z0); //dolny przedni
glVertex3fv(@punkt3); //glVertex3f(0, y0, z0);    //gorny

//koniec rysowania figury
glEnd;
end;

procedure TForm1.RysujOsie(rozmiar :Single);
begin
glBegin(GL_LINES);
glColor3ub(255,255,255);
glVertex3f(0,0,0); glVertex3f(rozmiar,0,0); //OX, w prawo
glVertex3f(0,0,0); glVertex3f(0,rozmiar,0); //OY, do gory
glVertex3f(0,0,0); glVertex3f(0,0,rozmiar); //OZ, w glab
glEnd;
end;

procedure TForm1.Rysuj;
const x0=1.0; y0=1.5; z0=1.0;
begin
//Przygotowanie bufora
glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
glLoadIdentity; //biezaca macierz = I
//glTranslatef(0.0, 0.0, -10.0); //odsuniecie calosci o 10

gluLookAt(KameraX,KameraY,KameraZ,  //polozenie oka
          0,0,0,  //polozenie srodka ukladu wsp.
          0,1,0); //kierunek "do gory"

RysujOsie(x0);

if Sfera then RysujGLU(x0/2);

//obroty
glRotatef(Phi, 0.0, 1.0, 0.0); //wokol OY
glRotatef(Theta, 1.0, 0.0, 0.0); //wokol OX

//przesuniecia
glTranslatef(PozycjaX,PozycjaY,PozycjaZ);

RysujOstroslup(x0,y0,z0);

//Z bufora na ekran
SwapBuffers(wglGetCurrentDC);
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
Rysuj;
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
case Key of
  Ord('Q'):  Timer1.Enabled:=not Timer1.Enabled;
  Ord('W'):  RuchKamery:=not RuchKamery;
  Ord('E'):  Kolory:=not Kolory;
  Ord('R'):  if glIsEnabled(GL_BLEND) then glDisable(GL_BLEND) else glEnable(GL_BLEND);
  Ord('T'):
    if glIsEnabled(GL_POINT_SMOOTH) then
      begin
      glDisable(GL_POINT_SMOOTH);
      glDisable(GL_LINE_SMOOTH);
      glDisable(GL_POLYGON_SMOOTH);
      end
      else
      begin
      glEnable(GL_POINT_SMOOTH);
      glEnable(GL_LINE_SMOOTH);
      glEnable(GL_POLYGON_SMOOTH);
      end;
  Ord('Y'):  Sfera:=not Sfera;
  Ord('U'):  SferaTekstura:=not SferaTekstura;
  Ord('1'):  if glIsEnabled(GL_LIGHT0) then glDisable(GL_LIGHT0) else glEnable(GL_LIGHT0);
  Ord('2'):  if glIsEnabled(GL_LIGHT1) then glDisable(GL_LIGHT1) else glEnable(GL_LIGHT1);
  Ord('3'):  if glIsEnabled(GL_LIGHT2) then glDisable(GL_LIGHT2) else glEnable(GL_LIGHT2);
  Ord('4'):  if glIsEnabled(GL_LIGHT3) then glDisable(GL_LIGHT3) else glEnable(GL_LIGHT3);
  VK_ESCAPE: Close;
  VK_F1: Pomoc;
end;
//obroty
if Shift=[] then
case Key of
  VK_LEFT :Phi:=Phi-3;
  VK_RIGHT :Phi:=Phi+3;
  VK_UP :Theta:=Theta-3;
  VK_DOWN :Theta:=Theta+3;
end;
//przesuniecia
if Shift=[ssCtrl] then
case Key of
  VK_LEFT :PozycjaX:=PozycjaX-0.1;
  VK_RIGHT :PozycjaX:=PozycjaX+0.1;
  VK_UP :PozycjaY:=PozycjaY+0.1;
  VK_DOWN :PozycjaY:=PozycjaY-0.1;
end;
if Shift=[ssShift] then
case Key of
  VK_LEFT :PozycjaX:=PozycjaX-0.1;
  VK_RIGHT :PozycjaX:=PozycjaX+0.1;
  VK_UP :PozycjaZ:=PozycjaZ-0.1;
  VK_DOWN :PozycjaZ:=PozycjaZ+0.1;
end;
//rysowanie
Rysuj;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
Phi:=Phi+1;
Rysuj;
end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
const PI_2=PI/2.0;
var
  srodek :TPoint;
  dX,dY :Double;
  R,_Phi,_Theta :Double;
begin
if not RuchKamery then Exit;

srodek.X:=ClientWidth div 2;
srodek.Y:=ClientHeight div 2;
dX:=PI_2*(X-srodek.X)/srodek.X;
dY:=-PI_2*(Y-srodek.Y)/srodek.Y; //minus bo wsp. Y jest skierowana inaczej we wsp. ekranu i w XYZ z OpenGL

R:=Sqrt(KameraX*KameraX+KameraY*KameraY+KameraZ*KameraZ);
_Theta:=Sqrt(dX*dX+dY*dY); //To jest przeksztalcenie z 2D kart. do 3D sferyczne (model)
_Phi:=ArcTan2(dY,dX);

KameraX:=R*cos(_Phi)*sin(_Theta);
KameraY:=R*sin(_Phi)*sin(_Theta);
KameraZ:=R*cos(_Theta);

//Caption:='OpenGL '+glGetString(GL_VERSION)+':  Kamera  dX='+FloatToStr(dX)+', dY='+FloatToStr(dY);
Caption:='OpenGL '+glGetString(GL_VERSION)+':  Kamera  odl='+FloatToStr(R)+', Phi='+IntToStr(Round(180*_Phi/PI))+', Theta='+IntToStr(Round(180*_Theta/PI));
//Caption:='OpenGL '+glGetString(GL_VERSION)+':  Kamera (X,Y,Z)=('+FloatToStr(KameraX)+', '+FloatToStr(KameraY)+', '+FloatToStr(KameraZ)+')';
Rysuj;
end;

procedure TForm1.FormMouseWheel(Sender: TObject; Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
const wsp=0.1;
begin
//proporcjonalna zmiana pozycji wszystkich wsp. kamery
KameraX:=KameraX*(1+Sign(WheelDelta)*wsp);
KameraY:=KameraY*(1+Sign(WheelDelta)*wsp);
KameraZ:=KameraZ*(1+Sign(WheelDelta)*wsp);
Rysuj;
end;

procedure TForm1.GL_Oswietlenie;
const
  kolor_otoczenie :TGLArrayf3 =(0.5,0.5,0.5); //biel
begin
glEnable(GL_LIGHTING); //wlaczenie systemu oswietlania

glLightModelfv(GL_LIGHT_MODEL_AMBIENT,@kolor_otoczenie); //swiatlo tla

glEnable(GL_COLOR_MATERIAL);
glColorMaterial(GL_FRONT,GL_AMBIENT_AND_DIFFUSE);

Swiatlo0;
Swiatlo1;
Swiatlo2;
Swiatlo3;
end;

procedure TForm1.Swiatlo0;
const
  kolor0_rozproszone :TGLArrayf4 =(0.5,0.5,0.5,1.0);
begin
glLightfv(GL_LIGHT0, GL_DIFFUSE, @kolor0_rozproszone);
glENABLE(GL_LIGHT0);
end;

procedure TForm1.Swiatlo1;
const
  kolor1_rozproszone :TGLArrayf4 =(0.3,0.3,0.3,1.0);
  kolor1_reflektora :TGLArrayf4 =(1.0,1.0,1.0,1.0);
  pozycja :TGLArrayf4 =(0.0,-10.0,0.0,1.0);
  kierunek :TGLArrayf4 =(0.0,1.0,0.0,1.0);
  szerokosc_wiazki = 60.0; //w stopniach
begin
glLightfv(GL_LIGHT1, GL_POSITION, @pozycja);
glLightfv(GL_LIGHT1, GL_DIFFUSE, @kolor1_rozproszone);
glLightfv(GL_LIGHT1, GL_SPECULAR, @kolor1_reflektora);
glLightfv(GL_LIGHT1, GL_SPOT_DIRECTION, @kierunek);
glLightf(GL_LIGHT1, GL_SPOT_CUTOFF, szerokosc_wiazki);
glENABLE(GL_LIGHT1);
end;

procedure TForm1.Swiatlo2;
const
  kolor2_rozproszone :TGLArrayf4 =(10.0,0.0,0.0,1.0);
  kolor2_reflektora :TGLArrayf4 =(10.0,0.0,0.0,1.0);
  pozycja :TGLArrayf4 =(10.0,0.0,0.0,1.0);
  kierunek :TGLArrayf4 =(-1.0,0.0,0.0,1.0);
  szerokosc_wiazki = 60.0; //w stopniach
begin
glLightfv(GL_LIGHT2, GL_POSITION, @pozycja);
glLightfv(GL_LIGHT2, GL_DIFFUSE, @kolor2_rozproszone);
glLightfv(GL_LIGHT2, GL_SPECULAR, @kolor2_reflektora);
glLightfv(GL_LIGHT2, GL_SPOT_DIRECTION, @kierunek);
glLightf(GL_LIGHT2, GL_SPOT_CUTOFF, szerokosc_wiazki);
//glENABLE(GL_LIGHT2);
end;

procedure TForm1.Swiatlo3;
const
  kolor3_rozproszone :TGLArrayf4 =(0.0,10.0,0.0,1.0);
  kolor3_reflektora :TGLArrayf4 =(0.0,10.0,0.0,1.0);
  pozycja :TGLArrayf4 =(-10.0,0.0,0.0,1.0);
  kierunek :TGLArrayf4 =(1.0,0.0,0.0,1.0);
  szerokosc_wiazki = 60.0; //w stopniach
begin
glLightfv(GL_LIGHT3, GL_POSITION, @pozycja);
glLightfv(GL_LIGHT3, GL_DIFFUSE, @kolor3_rozproszone);
glLightfv(GL_LIGHT3, GL_SPECULAR, @kolor3_reflektora);
glLightfv(GL_LIGHT3, GL_SPOT_DIRECTION, @kierunek);
glLightf(GL_LIGHT3, GL_SPOT_CUTOFF, szerokosc_wiazki);
//glENABLE(GL_LIGHT3);
end;

procedure TForm1.RysujGLU(rozmiar :Single);
var
  kwadryka :GLUQuadricObj;
begin
glColor4ub(255,255,255,255);
kwadryka:=gluNewQuadric; //tworzenie obiektu kwadryki
gluQuadricDrawStyle(kwadryka,GLU_FILL); //GLU_LINE, GLU_POINT, GLU_SILHOUETTE, GLU_FILL (domyslne)

if SferaTekstura then
  begin
  gluQuadricTexture(kwadryka,GL_TRUE);
  glEnable(GL_TEXTURE_2D);
  if Length(Tekstura)=0 then PrzygotujTeksture; //wywolywane tylko raz
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  gluBuild2DMipmaps(GL_TEXTURE_2D, 3, TeksturaSzer, TeksturaWys, GL_RGBA, GL_UNSIGNED_BYTE, Addr(Tekstura[0]));
  end;

gluSphere(kwadryka,rozmiar,30,30); //rysowanie
gluDeleteQuadric(kwadryka); //usuwanie obiektu

if SferaTekstura then glDisable(GL_TEXTURE_2D);
end;

procedure TForm1.PrzygotujTeksture;
const PlikTekstury='tekstura.jpg';
var
  obrazJPEG :TJPEGImage;
  obrazBMP :TBitmap;
  ih,iw :Integer;
  linia :^Longword;
  c :Longword;
begin
//ladowanie tekstury z pliku
obrazJPEG:=TJPEGImage.Create;
try
  obrazJPEG.LoadFromFile(PlikTekstury);
except
  ShowMessage('Brak pliku tekstury');
  SferaTekstura:=False;
  Exit;
end;
obrazBMP:=TBitmap.Create;
obrazBMP.PixelFormat:=pf32bit;
obrazBMP.Width:=obrazJPEG.Width;
obrazBMP.Height:=obrazJPEG.Height;
obrazBMP.Canvas.Draw(0,0,obrazJPEG);
obrazJPEG.Free;

//kopiowanie do dynamicznej tablicy RGBA
TeksturaSzer:=obrazBMP.Width;
TeksturaWys:=obrazBMP.Height;
SetLength(Tekstura,TeksturaSzer*TeksturaWys);
for ih:=0 to TeksturaWys-1 do
  begin
  linia:=obrazBMP.ScanLine[ih];
  for iw:=0 to TeksturaSzer-1 do
    begin
    c:=linia^ and $FFFFFF;
    Tekstura[iw+(ih*TeksturaSzer)]:=(((c and $FF) shl 16)+(c shr 16)+(c and $FF00)) or $FF000000;  //podzial na 4 kanaly: RGBA
    Inc(linia);
    end;
  end;
obrazBMP.Free;
end;

procedure TForm1.Pomoc;
begin
ShowMessage('OpenGL, wersja '+glGetString(GL_VERSION)+#13+
            'GLU, wersja '+gluGetString(GLU_VERSION)+#13+#13+
            'Klawisze:'+#13+
            '1-4 - rda wiata'+#13+
            'Q   - Animacja'+#13+
            'W   - Kontrola kamery myszk'+#13+
            'E   - Kolory cian'+#13+
            'R   - Przezroczysto czerwonej ciany'+#13+
            'T   - Antyaliasing'+#13+
            'Y   - Sfera (GLU)'+#13+
            'U   - Teksturowanie sfery'+#13+#13+
            '(c) Jacek Matulewski 2005'+#13+
            '(przykad ze skryptu nt. OpenGL 1.1)');
end;

end.
